﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;

namespace SetOutExpress
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void rectToolStripMenuItem_Click(object sender, EventArgs e)
        {
            polarToolStripMenuItem.Checked = !rectToolStripMenuItem.Checked;
            SetUpForm();
        }

        private void polarToolStripMenuItem_Click(object sender, EventArgs e)
        {
            rectToolStripMenuItem.Checked = !polarToolStripMenuItem.Checked;
            SetUpForm();
        }
        private void traceToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SetUpForm();
        }

        private void label1_Click(object sender, EventArgs e)
        {

        }
        private void SetUpForm()
        {
            lblTrace.Visible = traceToolStripMenuItem.Checked;
            txtTrace.Visible = traceToolStripMenuItem.Checked;
            if (polarToolStripMenuItem.Checked)
            {
                lblVar1.Text = "Target East";
                lblVar2.Text = "Target North";
                lblAns1.Text = "Distance";
                lblAns1.Text = "Bearing";
            }
            else
            {
                lblVar1.Text = "Distance";
                lblVar2.Text = "Bearing";
                lblAns1.Text = "Target East";
                lblAns2.Text = "Target North";
            }
            txtVar1.Text = "";
            txtVar2.Text = "";
            txtAns1.Text = "";
            txtAns2.Text = "";

            
        }

        private void textBox6_TextChanged(object sender, EventArgs e)
        {

        }

        private void label6_Click(object sender, EventArgs e)
        {

        }

        private void lblVar1Err_Click(object sender, EventArgs e)
        {

        }

        private void btnCalculate_Click(object sender, EventArgs e)
        {

            try
            {
                txtTrace.Text = "";
                lblVar1Err.Visible = false;
                lblVar2Err.Visible = false;
                lblStatEastErr.Visible = false;
                lblStatNorthErr.Visible = false;
                Double stationEast;
                Double stationNorth;
                Double targetEast;
                Double targetNorth ;

                if (!Double.TryParse(txtStnEast.Text, out stationEast))
                {
                    lblStatEastErr.Visible = true;
                    return;
                }
                if (!Double.TryParse(txtStnNorth.Text, out stationNorth))
                {
                    lblStatNorthErr.Visible = true;
                    return;
                }
                if (!Double.TryParse(txtVar1.Text, out targetEast))
                {
                    lblVar1Err.Text = "Invalid number";
                    lblVar1Err.Visible = true;
                    return;
                }
                if (polarToolStripMenuItem.Checked)
                {

                    if (!Double.TryParse(txtVar2.Text, out targetNorth))
                    {
                        lblVar1Err.Text = "Invalid number";
                        lblVar2Err.Visible = true;
                        return;
                    }
                    pol(stationEast, stationNorth, targetEast, targetNorth);
                }
                else
                {
                    Regex dmsReg = new Regex("^(\\d+):([0-5][0-9]):([0-5][0-9])$");
                    Match dmsMatch = dmsReg.Match(txtVar2.Text.Trim());
                    if (!dmsMatch.Success)
                    {
                        lblVar2Err.Text = "Invalid e.g. 45:00:00";
                        lblVar2Err.Visible = true;
                        return;
                    }
                    int degs = int.Parse(dmsMatch.Groups[1].ToString());
                    int mins = int.Parse(dmsMatch.Groups[2].ToString());
                    int secs = int.Parse(dmsMatch.Groups[3].ToString());
                    double rad = (Math.PI * (degs + (mins / 60.0) + (secs / 3600.0))) / 180.0;
                    rect(stationEast, stationNorth, Double.Parse(txtVar1.Text), rad);

                }
            }
            catch (Exception ex)
            {
                txtTrace.Text = ex.Message + "\r\n" + ex.Source + "\r\n" + ex.StackTrace;
            }

        }

        private void pol(Double stationEast, Double stationNorth, Double targetEast, Double targetNorth)
        {
            double diffe = targetEast - stationEast;
            double diffn = targetNorth - stationNorth;
            txtAns1.Text = String.Format("{0:#0.000}",Math.Round(Math.Sqrt(diffe * diffe + diffn * diffn ), 3));
            txtAns2.Text = ToDMS(rad2bear(diffe, diffn));

        }

        public void rect(double se, double sn, double dis, double rad)
        {
            txtAns1.Text = String.Format("{0:#0.000}" , (se + dis * Math.Sin(rad)));
            txtAns2.Text = String.Format("{0:#0.000}", (sn + dis * Math.Cos(rad)));
        }	

        public double rad2bear(double de, double dn)
        {
            int quad = 1;
            double radbear;
            if (dn < 0)
            {
                if (de < 0)
                {
                    quad = 3;
                }
                else
                {
                    quad = 2;
                }
            }
            if ((dn > 0) && (de < 0))
            {
                quad = 4;
            }
            if (Math.Abs(dn) > 0)
            {
                radbear = Math.Atan(de / dn);
            }
            else
            {
                radbear = Math.PI / 2;
                if (de < 0)
                {
                    radbear += Math.PI;
                }
            }
            if (quad == 2)
            {
                radbear += Math.PI;
            }
            if (quad == 3)
            {
                radbear += Math.PI;
            }
            if (quad == 4)
            {
                radbear += Math.PI * 2;
            }
            if ((Math.Abs(de) < 0.001) && (Math.Abs(dn) < 0.001))
            {
                radbear = 0;
            }
            return radbear;
        }

        public String ToDMS(double radang)
        {
            int degs, mins, secs;
            double dmsang, dsecs, temp;
            dmsang = radang * 180 / Math.PI;
            while (dmsang < 360)
            {
                dmsang += 360;
            }
            while (dmsang >= 360)
            {
                dmsang -= 360;
            }
            degs = (int)Math.Floor(dmsang);
            mins = (int)Math.Floor((dmsang - degs) * 60);
            dsecs = (dmsang - degs - mins / 60.0) * 3600;
            temp = dsecs - Math.Floor(dsecs);
            if (temp > 0.5)
            {
                dsecs += 1;
            }
            secs = (int)Math.Floor(dsecs);
            if (secs == 60)
            {
                secs = 0; mins += 1;
            }
            if (mins == 60)
            {
                mins = 0; degs += 1;
            }
            if (degs == 360)
            {
                degs = 0;
            }
            return String.Format("{0:00}:{1:00}:{2:00}" ,degs ,  mins , secs);
        }

        private void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            AboutBox1 a = new AboutBox1();
            a.ShowDialog();
        }

        
    }
}
